document.addEventListener('DOMContentLoaded', function() {
    const contactForm = document.getElementById('contactForm');
    if (contactForm) {
        contactForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            const formAlert = document.getElementById('formAlert');
            formAlert.textContent = 'Sending...';

            const data = {
                name: contactForm.name.value,
                email: contactForm.email.value,
                message: contactForm.message.value
            };

            try {
                const response = await fetch('/api/contact', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(data)
                });
                const result = await response.json();
                if (result.success) {
                    formAlert.textContent = 'Message sent successfully!';
                    contactForm.reset();
                } else {
                    formAlert.textContent = 'Failed to send message. Try again.';
                }
            } catch (err) {
                formAlert.textContent = 'Error sending message.';
            }
        });
    }
});